CREATE OR REPLACE FUNCTION addColumn()
RETURNS VOID AS
$BODY$
BEGIN
    IF EXISTS (SELECT 1 
                 FROM information_schema.columns     
                WHERE table_name= 'pdv_vd_endereco' 
              ) THEN
                         
        RAISE NOTICE 'Tabela pdv_vd_endereco ja existe!' ;
        
    ELSE
        
           CREATE TABLE public.pdv_vd_endereco (
           	    cd_emp            numeric(6)  NOT NULL DEFAULT 0,
           	    cd_filial         numeric(6)  NOT NULL DEFAULT 0,
           	    cd_vd             numeric(10) NOT NULL DEFAULT 0,
           	    cd_cx             numeric(6)  NOT NULL DEFAULT 0,
           	    cep               varchar(50) NULL,
           	    cd_municipio_ibge varchar(50) NULL,
           	    nr_nro            numeric(6)  NOT NULL DEFAULT 0,
           	    complemento       varchar(50) NULL,
           	    end_cli           varchar(300)NULL,
           	    bairro            varchar(50) NULL,
           	    ds_cid            varchar(100)NULL,
           	    uf                varchar(2)  NULL,
           	    cd_pais           numeric(6)  NOT NULL DEFAULT 1058,
           	    ds_pais           varchar(50) NOT NULL DEFAULT 'BRASIL',
           	    CONSTRAINT pdv_vd_endereco_pkey PRIMARY KEY (cd_emp, cd_filial, cd_vd, cd_cx)
                );
           
            ALTER TABLE public.pdv_vd_endereco OWNER TO postgres;
            GRANT ALL ON TABLE public.pdv_vd_endereco TO postgres;       
        RAISE NOTICE 'Tabela  pdv_vd_endereco criada com sucesso!';
    END IF; 
    
END; 
$BODY$
LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION addColumn()  OWNER TO postgres;
SELECT addColumn();
DROP FUNCTION addColumn();